/* - StepperAttachListener -
 * populate the available fields and controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.StepperPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class StepperAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JComboBox motorCmb;
    private JTextField velLimitTxt;
    private JTextField velActualTxt;
    private JTextField accelTxt;
    private JTextField posTargetTxt;
    private JTextField posActualTxt;
    private JTextField currentLimitTxt;
    private JTextField currentActualTxt;
    private JSlider velLimitScrl;
    private JSlider accelScrl;
    private JSlider targetPosScrl;
    private JSlider currentPosScrl;
    private JSlider currentLimitScrl;
    private JCheckBox inputArray[];
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel18;
    private JCheckBox engagedChk;
    private JCheckBox stoppedChk;
    
    /** Creates a new instance of StepperAttachListener */
    public StepperAttachListener(JFrame appFrame, JTextField attachedTxt,
                    JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
                    JTextField numMotorsTxt, JComboBox motorCmb, JTextField velLimitTxt,
                    JTextField velActualTxt, JTextField accelTxt, JTextField posTargetTxt,
                    JTextField posActualTxt, JTextField currentLimitTxt, JTextField currentActualTxt,
                    JSlider velLimitScrl, JSlider accelScrl, JSlider targetPosScrl,
                    JSlider currentPosScrl, JSlider currentLimitScrl, JCheckBox inputArray[],
                    JLabel jLabel11, JLabel jLabel12, JLabel jLabel18, JCheckBox engagedChk,
                    JCheckBox stoppedChk)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.motorCmb = motorCmb;
        this.velLimitTxt = velLimitTxt;
        this.velActualTxt = velActualTxt;
        this.accelTxt = accelTxt;
        this.posTargetTxt = posTargetTxt;
        this.posActualTxt = posActualTxt;
        this.currentLimitTxt = currentLimitTxt;
        this.currentActualTxt = currentActualTxt;
        this.engagedChk = engagedChk;
        this.stoppedChk = stoppedChk;
        this.velLimitScrl = velLimitScrl;
        this.accelScrl = accelScrl;
        this.targetPosScrl = targetPosScrl;
        this.currentPosScrl = currentPosScrl;
        this.currentLimitScrl = currentLimitScrl;
        this.inputArray = inputArray;
        this.jLabel11 = jLabel11;
        this.jLabel12 = jLabel12;
        this.jLabel18 = jLabel18;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            StepperPhidget attached = (StepperPhidget)ae.getSource();
            
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numMotorsTxt.setText(Integer.toString(attached.getMotorCount()));
            
            velLimitScrl.setMaximum((int)attached.getVelocityMax(0));
            velLimitScrl.setMinimum((int)attached.getVelocityMin(0));
            velLimitScrl.setMajorTickSpacing((int)attached.getVelocityMax(0) / 64);
            
            accelScrl.setMaximum((int)attached.getAccelerationMax(0));
            accelScrl.setMinimum((int)attached.getAccelerationMin(0));
            accelScrl.setMajorTickSpacing((int)attached.getAccelerationMin(0) * 4);
                    
            targetPosScrl.setMaximum(20000); //setting this to +-20000 because the maximum values are really large and this is just an example
            targetPosScrl.setMinimum(-20000);
            targetPosScrl.setMajorTickSpacing(1000);
            targetPosScrl.setMinorTickSpacing(100);
            
            currentPosScrl.setMaximum(20000); //setting this to +-20000 because the maximum values are really large and this is just an example
            currentPosScrl.setMinimum(-20000);
            currentPosScrl.setMajorTickSpacing(1000);
            currentPosScrl.setMinorTickSpacing(100);
            
            int i;
            for(i = 0; i < attached.getMotorCount(); i++)
            {
                motorCmb.addItem(new Integer(i));
            }
            motorCmb.setSelectedIndex(0);
            
            velLimitScrl.setValueIsAdjusting(true);
            velLimitScrl.setValue(velLimitScrl.getMinimum());
            velLimitScrl.setValueIsAdjusting(false);
            velLimitScrl.setEnabled(true);
            accelScrl.setValueIsAdjusting(true);
            accelScrl.setValue(accelScrl.getMinimum());
            accelScrl.setValueIsAdjusting(false);
            accelScrl.setEnabled(true);
            targetPosScrl.setValueIsAdjusting(true);
            targetPosScrl.setValue(0);
            targetPosScrl.setValueIsAdjusting(false);
            targetPosScrl.setEnabled(true);
            currentPosScrl.setValueIsAdjusting(true);
            currentPosScrl.setValue(0);
            currentPosScrl.setValueIsAdjusting(false);
            currentPosScrl.setEnabled(true);
            engagedChk.setEnabled(true);
            motorCmb.setEnabled(true);
            
            //Only a Bipolar stepper has access to these features
            if(attached.getDeviceName().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0)
            {
                jLabel12.setVisible(true);
                currentLimitTxt.setVisible(true);
                
                jLabel18.setVisible(true);
                currentActualTxt.setVisible(true);
                
                jLabel11.setVisible(true);
                currentLimitScrl.setMaximum((int)(attached.getCurrentMax(0) * 100.0));
                currentLimitScrl.setMinimum((int)(attached.getCurrentMin(0) * 100.0));
                currentLimitScrl.setMajorTickSpacing(5);
                currentLimitScrl.setVisible(true);
                currentLimitScrl.setEnabled(true);
                
                for(i = 0; i < attached.getInputCount(); i++)
                {
                    inputArray[i].setVisible(true);
                }
            }
            else
            {
                jLabel12.setVisible(false);
                currentLimitTxt.setVisible(false);
                
                jLabel18.setVisible(false);
                currentActualTxt.setVisible(false);
                
                jLabel11.setVisible(false);
                currentLimitScrl.setVisible(false);
                currentLimitScrl.setEnabled(false);
                
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
            }
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
